function [ T_exp, Y_exp ] = ExpDataForBatchCulture_IntracellularMetabolite(strain_no)
% Batch culture

switch strain_no
    % T_exp: Time (h)
    % Y_exp(:,1): PYR
    % Y_exp(:,2): MAL
    % Y_exp(:,3): PEP
    % Y_exp(:,4): DHAP
    % Y_exp(:,5): 2/3PG
    % Y_exp(:,6): Ru5P
    % Y_exp(:,7): R5P
    % Y_exp(:,8): G6P
    % Y_exp(:,9): 6PG
    % Y_exp(:,10): S7P
    % Y_exp(:,11): F1,6P
    
    % Wild Type (Toya 2010, Figure 5, open circles)
    case 1
        T_exp(1) =  4  ; Y_exp(1,1) = 0.31; Y_exp(1,2) = 0.20; Y_exp(1,3) = 0.05; Y_exp(1,4) = 0.28; Y_exp(1,5) = 0.12; Y_exp(1,6) = 0.20; Y_exp(1,7) = 0.07; Y_exp(1,8) = 0.28; Y_exp(1,9) = 0; Y_exp(1,10) = 0.07; Y_exp(1,11) = 0.09;
        T_exp(2) =  5  ; Y_exp(2,1) = 0.26; Y_exp(2,2) = 0.17; Y_exp(2,3) = 0.06; Y_exp(2,4) = 0.13; Y_exp(2,5) = 0.21; Y_exp(2,6) = 0.17; Y_exp(2,7) = 0.05; Y_exp(2,8) = 0.29; Y_exp(2,9) = 0; Y_exp(2,10) = 0.07; Y_exp(2,11) = 0.07;
        T_exp(3) =  6  ; Y_exp(3,1) = 0.08; Y_exp(3,2) = 0.26; Y_exp(3,3) = 0.14; Y_exp(3,4) = 0.14; Y_exp(3,5) = 0.48; Y_exp(3,6) = 0.18; Y_exp(3,7) = 0.06; Y_exp(3,8) = 0.29; Y_exp(3,9) = 0; Y_exp(3,10) = 0.08; Y_exp(3,11) = 0.19;
        T_exp(4) =  7  ; Y_exp(4,1) = 0.02; Y_exp(4,2) = 0.38; Y_exp(4,3) = 0.20; Y_exp(4,4) = 0.12; Y_exp(4,5) = 0.76; Y_exp(4,6) = 0.15; Y_exp(4,7) = 0.05; Y_exp(4,8) = 0.26; Y_exp(4,9) = 0; Y_exp(4,10) = 0.08; Y_exp(4,11) = 0.18;
        T_exp(5) =  8  ; Y_exp(5,1) = 0.01; Y_exp(5,2) = 0.13; Y_exp(5,3) = 0.07; Y_exp(5,4) = 0.10; Y_exp(5,5) = 0.27; Y_exp(5,6) = 0.09; Y_exp(5,7) = 0.03; Y_exp(5,8) = 0.22; Y_exp(5,9) = 0; Y_exp(5,10) = 0.05; Y_exp(5,11) = 0.04;
        T_exp(6) =  8.5; Y_exp(6,1) = 0.02; Y_exp(6,2) = 0.10; Y_exp(6,3) = 0.11; Y_exp(6,4) = 0.08; Y_exp(6,5) = 0.48; Y_exp(6,6) = 0.09; Y_exp(6,7) = 0.00; Y_exp(6,8) = 0.23; Y_exp(6,9) = 0; Y_exp(6,10) = 0.05; Y_exp(6,11) = 0.02;
        T_exp(7) =  9  ; Y_exp(7,1) = 0.04; Y_exp(7,2) = 0.05; Y_exp(7,3) = 0.40; Y_exp(7,4) = 0.02; Y_exp(7,5) = 0.56; Y_exp(7,6) = 0.05; Y_exp(7,7) = 0.00; Y_exp(7,8) = 0.00; Y_exp(7,9) = 0; Y_exp(7,10) = 0.02; Y_exp(7,11) = 0.00;
        T_exp(8) = 10  ; Y_exp(8,1) = 0.02; Y_exp(8,2) = 0.04; Y_exp(8,3) = 0.06; Y_exp(8,4) = 0.07; Y_exp(8,5) = 0.23; Y_exp(8,6) = 0.09; Y_exp(8,7) = 0.00; Y_exp(8,8) = 0.16; Y_exp(8,9) = 0; Y_exp(8,10) = 0.04; Y_exp(8,11) = 0.02;
        
    % DeltaPyk (Toya 2010, Figure 5, filled black triangles)
    case 2
        T_exp(1) = 5; Y_exp(1,1) = 0.03; Y_exp(1,2) = 0.89; Y_exp(1,3) = 2.54; Y_exp(1,4) = 0.38; Y_exp(1,5) =  7.64; Y_exp(1,6) = 0.40; Y_exp(1,7) = 0.12; Y_exp(1,8) = 0.24; Y_exp(1,9) = 0; Y_exp(1,10) = 0.20; Y_exp(1,11) = 0.16;
        T_exp(2) = 6; Y_exp(2,1) = 0.09; Y_exp(2,2) = 3.23; Y_exp(2,3) = 1.55; Y_exp(2,4) = 1.13; Y_exp(2,5) =  8.54; Y_exp(2,6) = 0.68; Y_exp(2,7) = 0.31; Y_exp(2,8) = 0.85; Y_exp(2,9) = 0; Y_exp(2,10) = 0.25; Y_exp(2,11) = 4.80;
        T_exp(3) = 7; Y_exp(3,1) = 0.02; Y_exp(3,2) = 1.74; Y_exp(3,3) = 4.09; Y_exp(3,4) = 0.65; Y_exp(3,5) = 16.02; Y_exp(3,6) = 0.53; Y_exp(3,7) = 0.17; Y_exp(3,8) = 0.40; Y_exp(3,9) = 0; Y_exp(3,10) = 0.24; Y_exp(3,11) = 1.76;
        T_exp(4) = 8; Y_exp(4,1) = 0.00; Y_exp(4,2) = 0.38; Y_exp(4,3) = 3.90; Y_exp(4,4) = 0.16; Y_exp(4,5) = 15.29; Y_exp(4,6) = 0.26; Y_exp(4,7) = 0.07; Y_exp(4,8) = 0.21; Y_exp(4,9) = 0; Y_exp(4,10) = 0.15; Y_exp(4,11) = 0.04;
        T_exp(5) = 9; Y_exp(5,1) = 0.02; Y_exp(5,2) = 0.09; Y_exp(5,3) = 0.79; Y_exp(5,4) = 0.08; Y_exp(5,5) =  5.21; Y_exp(5,6) = 0.14; Y_exp(5,7) = 0.04; Y_exp(5,8) = 0.09; Y_exp(5,9) = 0; Y_exp(5,10) = 0.10; Y_exp(5,11) = 0.01;
        
    % DeltaPgi (Toya 2010, Figure 5, filled black squares)
    case 3
        T_exp(1) = 16; Y_exp(1,1) = 0.33; Y_exp(1,2) = 0.29; Y_exp(1,3) = 0.01; Y_exp(1,4) = 0.76; Y_exp(1,5) = 0.09; Y_exp(1,6) = 0.49; Y_exp(1,7) = 0.18; Y_exp(1,8) = 5.29; Y_exp(1,9) = 0.85; Y_exp(1,10) = 0.16; Y_exp(1,11) = 0.24;
        T_exp(2) = 18; Y_exp(2,1) = 0.15; Y_exp(2,2) = 0.26; Y_exp(2,3) = 0.02; Y_exp(2,4) = 0.78; Y_exp(2,5) = 0.15; Y_exp(2,6) = 0.45; Y_exp(2,7) = 0.16; Y_exp(2,8) = 4.36; Y_exp(2,9) = 0.65; Y_exp(2,10) = 0.16; Y_exp(2,11) = 0.31;
        T_exp(3) = 20; Y_exp(3,1) = 0.09; Y_exp(3,2) = 0.33; Y_exp(3,3) = 0.01; Y_exp(3,4) = 0.87; Y_exp(3,5) = 0.19; Y_exp(3,6) = 0.52; Y_exp(3,7) = 0.19; Y_exp(3,8) = 5.96; Y_exp(3,9) = 1.33; Y_exp(3,10) = 0.18; Y_exp(3,11) = 0.58;
        T_exp(4) = 21; Y_exp(4,1) = 0.21; Y_exp(4,2) = 0.29; Y_exp(4,3) = 0.02; Y_exp(4,4) = 0.68; Y_exp(4,5) = 0.21; Y_exp(4,6) = 0.41; Y_exp(4,7) = 0.14; Y_exp(4,8) = 3.62; Y_exp(4,9) = 0.58; Y_exp(4,10) = 0.18; Y_exp(4,11) = 0.48;
        T_exp(5) = 22; Y_exp(5,1) = 0.27; Y_exp(5,2) = 0.30; Y_exp(5,3) = 0.02; Y_exp(5,4) = 0.72; Y_exp(5,5) = 0.22; Y_exp(5,6) = 0.43; Y_exp(5,7) = 0.14; Y_exp(5,8) = 3.90; Y_exp(5,9) = 0.83; Y_exp(5,10) = 0.17; Y_exp(5,11) = 0.51;
        T_exp(6) = 23; Y_exp(6,1) = 0.43; Y_exp(6,2) = 0.38; Y_exp(6,3) = 0.04; Y_exp(6,4) = 0.67; Y_exp(6,5) = 0.34; Y_exp(6,6) = 0.40; Y_exp(6,7) = 0.14; Y_exp(6,8) = 3.51; Y_exp(6,9) = 0.53; Y_exp(6,10) = 0.20; Y_exp(6,11) = 0.39;
        
    otherwise
        fprintf('Unexpected Strain Name!\n');
end

 	 	 		 	