function Flux = ExpDataForContinuousCulture(SampleID)
% For details see supporting xls file of the following paper.
% Ishii N, Nakahigashi K, Baba T, Robert M, Soga T, Kanai A, Hirasawa T,
% Naba M, Hirai K, Hoque A et al: Multiple high-throughput analyses monitor
% the response of E-coli to perturbations. Science 2007, 316(5824):593-597.
%
% Elements of Flux
%  1: Glucose + PEP -> G6P + PYR
%  2: G6P <-> F6P
%  3: F6P -> F1,6P
%  4: F1,6P -> DHAP + G3P
%  5: DHAP -> G3P
%  6: G3P -> 3PG
%  7: 3PG <-> PEP
%  8: PEP -> PYR
%  9: PYR -> AcCoA + CO2
% 10: G6P -> 6PG
% 11: 6PG -> Ru5P + CO2
% 12: Ru5P -> X5P
% 13: Ru5P -> R5P
% 14: R5P + X5P <-> S7P + G3P
% 15: S7P + G3P <-> E4P + F6P
% 16: X5P + E4P <-> F6P + G3P
% 17: AcCoA + OAA -> CIT
% 18: CIT -> ICT
% 19: ICT -> 2-KG + CO2
% 20: 2-KG -> SUC + CO2
% 21: SUC -> FUM
% 22: FUM -> MAL
% 23: MAL <-> OAA
% 24: PEP + CO2 <-> OAA
% 25: MAL -> PYR + CO2
% 26: ICT -> Glyoxylate + SUC
% 27: Glyoxylate + AcCoA -> MAL
% 28: 6-PG -> G3P + PYR
% 29: AcCoA -> Acetate
% 30: PYR -> Lactate
% 31: AcCoA -> Ethanol
% 32: G6P -> (Cell synthesis)
% 33: F6P -> (Cell synthesis)
% 34: R5P -> (Cell synthesis)
% 35: E4P -> (Cell synthesis)
% 36: G3P -> (Cell synthesis)
% 37: 3PG -> (Cell synthesis)
% 38: PEP -> (Cell synthesis)
% 39: PYR -> (Cell synthesis)
% 40: AcCoA -> (Cell synthesis)
% 41: OAA -> (Cell synthesis)
% 42: 2KG -> (Cell synthesis)
% 43: CO2 -> (Evolution)
% 44: Exch. (G6P <-> F6P)
% 45: Exch. (3PG <-> PEP)
% 46: Exch. (R5P + X5P <-> S7P + G3P)
% 47: Exch. (S7P + G3P <-> E4P + F6P)
% 48: Exch. (X5P + E4P <-> F6P + G3P)
% 49: Exch. (MAL <-> OAA)
% 50: Exch. (PEP + CO2 <-> OAA)


switch SampleID
    
    case 'RF06' % RF06 WT(Oct),WT, D=0.2h-1
        Flux = [ 100, 60, 79, 79, 79, 164, 153, 49, 126, 39,...
            39, 20, 19, 12, 12, 8, 72, 72, 49, 40,...
            63, 63, 86, 0, 0, 23, 23, 0, 0, 0,...
            0, 2, 1, 7, 3, 1, 11, 4, 23, 31,...
            15, 9, 252, 0.68, 0.95, 0.00, 0.83, 0.00, 0.75, 0.34 ];
        
    case 'GR02' % GR02 WT, D=0.4h-1
        Flux = [ 100, 63, 79, 79, 79, 165, 153, 25, 101, 36,...
            36, 18, 18, 11, 11, 7, 70, 70, 70, 60,...
            60, 60, 60, 25, 0, 0, 0, 0, 0, 0,...
            0, 2, 1, 8, 3, 1, 11, 4, 24, 31,...
            15, 9, 243, 0.95, 0.95, 0.09, 0.52, 0.12, 0.95, 0.37 ];
        
    case 'GR03' % GR03 WT, D=0.5h-1
        Flux = [ 100, 83, 87, 87, 87, 173, 162, 34, 112, 15,...
            15, 4, 11, 4, 4, 0, 72, 72, 72, 63,...
            63, 63, 63, 24, 0, 0, 0, 0, 7, 0,...
            2, 2, 1, 7, 3, 1, 11, 4, 23, 30,...
            15, 9, 238, 0.93, 0.00, 0.07, 0.54, 0.01, 0.87, 0.10 ];
        
    case 'GR04' % GR04 WT, D=0.7h-1
        Flux = [ 100, 56, 80, 80, 80, 170, 162, 43, 127, 42,...
            42, 24, 18, 13, 13, 11, 89, 89, 89, 83,...
            83, 83, 83, 17, 0, 0, 0, 0, 14, 0,...
            1, 1, 1, 5, 2, 1, 8, 3, 16, 21,...
            10, 6, 325, 0.95, 0.95, 0.00, 0.34, 0.00, 0.94, 0.23 ];
    otherwise
        fprintf('Unexpected SampleID!\n');
end
