clear all;
close all;

global strain_no continuous_flg;
[Yidx, Fidx] = setIndex();


options = odeset('RelTol',1e-10,'AbsTol',1e-10);
n_FLUX = 155;
ode_file = @JahanModel_ODE;
flux_file = @JahanModel_Flux;

%% Wile Type
strain_no = 1;
continuous_flg = 0;
span = -10:0.1:12;
y0 = getInitialCondition();
y0( 1) = 0.011;        % X
y0( 2) = 4.0/180*1e+3; % GLCex
y0(12) = 0.0/ 60*1e+3; % ACEex
[ T1, Y1, FLUX1 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y1 = real(Y1); FLUX1 = real(FLUX1);
plotSimulationResult(T1,Y1,FLUX1,strain_no,[0 max(span)],[0 5]);

%% DeltaPyk
strain_no = 2;
continuous_flg = 0;
span = -10:0.1:12;
y0 = getInitialCondition();
y0( 1) = 0.011;        % X
y0( 2) = 4.0/180*1e+3; % GLCex
y0(12) = 0.0/ 60*1e+3; % ACEex
y0(35) = 0; % Pyk
[ T2, Y2, FLUX2 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y2 = real(Y2); FLUX2 = real(FLUX2);
plotSimulationResult(T2,Y2,FLUX2,strain_no,[0 max(span)],[0 5]);

%% DeltaPgi
strain_no = 3;
continuous_flg = 0;
span = -10:0.1:30;
y0 = getInitialCondition();
y0( 1) = 0.011;        % X
y0( 2) = 4.0/180*1e+3; % GLCex
y0(12) = 0.0/ 60*1e+3; % ACEex
[ T3, Y3, FLUX3 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y3 = real(Y3); FLUX3 = real(FLUX3);
plotSimulationResult(T3,Y3,FLUX3,strain_no,[0 max(span)],[0 5]);

%% DeltaPpc
strain_no = 4;
continuous_flg = 0;
span = -10:0.1:15;
y0 = getInitialCondition();
y0( 1) = 0.011;         % X
y0( 2) = 4.74/180*1e+3; % GLCex
y0(12) = 0.0 / 60*1e+3; % ACEex
y0(48) = 0; % Ppc
[ T4, Y4, FLUX4 ] = runSimulation(ode_file,flux_file,span,y0,options);
Y4 = real(Y4); FLUX4 = real(FLUX4);
plotSimulationResult(T4,Y4,FLUX4,strain_no,[0 max(span)],[0 5]);

%% Metabolite comparison with Toya 2010
scrsz = get(0,'ScreenSize');
h = figure('Position',[10 scrsz(4)*0.24*0.5 scrsz(3)*0.24*3 scrsz(4)*0.24*3]);

[ T1_exp, Y1_exp ] = ExpDataForBatchCulture_IntracellularMetabolite(1);
[ T2_exp, Y2_exp ] = ExpDataForBatchCulture_IntracellularMetabolite(2);
[ T3_exp, Y3_exp ] = ExpDataForBatchCulture_IntracellularMetabolite(3);
% G6P
subplot(4,3,1)
hold on;
plot(T1_exp,Y1_exp(:,8),'bo',T2_exp,Y2_exp(:,8),'rd', T3_exp,Y3_exp(:,8),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('G6P (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.G6P),'b-', T2,Y2(:,Yidx.G6P), 'r-' ,T3,Y3(:,Yidx.G6P),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 10])
legend('WT','\Deltapyk','\Deltapgi');
hold off;
% F1,6P (FBP in our model)
subplot(4,3,2)
hold on;
plot(T1_exp,Y1_exp(:,11),'bo',T2_exp,Y2_exp(:,11),'rd',T3_exp,Y3_exp(:,11),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('FBP (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.FBP),'b-', T2,Y2(:,Yidx.FBP),'r-', T3,Y3(:,Yidx.FBP),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 5])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
% PEP
subplot(4,3,3)
hold on;
plot(T1_exp,Y1_exp(:,3),'bo',T2_exp,Y2_exp(:,3),'rd',T3_exp,Y3_exp(:,3),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('PEP (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.PEP),'b-', T2,Y2(:,Yidx.PEP),'r-', T3,Y3(:,Yidx.PEP),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 6])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
% PYR
subplot(4,3,4)
hold on;
plot(T1_exp,Y1_exp(:,1),'bo',T2_exp,Y2_exp(:,1),'rd',T3_exp,Y3_exp(:,1),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('PYR (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.PYR),'b-', T2,Y2(:,Yidx.PYR),'r-', T3,Y3(:,Yidx.PYR),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 1])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
% MAL
subplot(4,3,5)
hold on;
plot(T1_exp,Y1_exp(:,2),'bo',T2_exp,Y2_exp(:,2),'rd',T3_exp,Y3_exp(:,2),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('MAL (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.MAL),'b-', T2,Y2(:,Yidx.MAL),'r-', T3,Y3(:,Yidx.MAL),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 4])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
% 6PG
subplot(4,3,6)
hold on;
plot(T1_exp,Y1_exp(:,9),'bo',T2_exp,Y2_exp(:,9),'rd',T3_exp,Y3_exp(:,9),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('6PG (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.sixPG),'b-', T2,Y2(:,Yidx.sixPG),'r-', T3,Y3(:,Yidx.sixPG),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 1.5])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
% Ru5P (RU5P in our model)
subplot(4,3,7)
hold on;
plot(T1_exp,Y1_exp(:,6),'bo',T2_exp,Y2_exp(:,6),'rd',T3_exp,Y3_exp(:,6),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('RU5P (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.RU5P),'b-', T2,Y2(:,Yidx.RU5P),'r-', T3,Y3(:,Yidx.RU5P),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 1])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
% R5P
subplot(4,3,8)
hold on;
plot(T1_exp,Y1_exp(:,7),'bo',T2_exp,Y2_exp(:,7),'rd',T3_exp,Y3_exp(:,7),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('R5P (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.R5P),'b-', T2,Y2(:,Yidx.R5P),'r-', T3,Y3(:,Yidx.R5P),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 0.4])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;
subplot(4,3,9)
hold on;
plot(T1_exp,Y1_exp(:,10),'bo',T2_exp,Y2_exp(:,10),'rd',T3_exp,Y3_exp(:,10),'gs');
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('S7P (mM)','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
plot(T1,Y1(:,Yidx.S7P),'b-', T2,Y2(:,Yidx.S7P),'r-', T3,Y3(:,Yidx.S7P),'g-', 'LineWidth',2);
xlim( [ 0 max([T1(end) T2(end) T3(end)]) ] )
ylim([0 0.4])
% legend('WT','\Deltapyk','\Deltapgi');
hold off;

%% WT (growth phase and stationary phase) Flux in comparison with Toya 2010
[ T1_exp, F1_exp ] = ExpDataForBatchCulture_Flux(1);
F1_sim(:, 1) = FLUX1(:,3);
F1_sim(:, 2) = FLUX1(:,8);
F1_sim(:, 3) = FLUX1(:, 9) - FLUX1(:,10);
F1_sim(:, 4) = FLUX1(:,11);
F1_sim(:, 5) = 0; % F_sim does not have Tpi
F1_sim(:, 6) = FLUX1(:,12);
F1_sim(:, 7) = FLUX1(:,12);
F1_sim(:, 8) = FLUX1(:,13) - FLUX1(:,14);
F1_sim(:, 9) = FLUX1(:,15);
F1_sim(:,10) = FLUX1(:,17);
F1_sim(:,11) = FLUX1(:,34);
F1_sim(:,12) = FLUX1(:,38);
F1_sim(:,13) = FLUX1(:,40);
F1_sim(:,14) = FLUX1(:,39);
F1_sim(:,15) = FLUX1(:,41);
F1_sim(:,16) = FLUX1(:,43);
F1_sim(:,17) = FLUX1(:,42);
F1_sim(:,18) = FLUX1(:,21);
F1_sim(:,19) = FLUX1(:,22);
F1_sim(:,20) = FLUX1(:,23);
F1_sim(:,21) = FLUX1(:,24);
F1_sim(:,22) = FLUX1(:,25);
F1_sim(:,23) = FLUX1(:,26);
F1_sim(:,24) = FLUX1(:,29) - FLUX1(:,28);
F1_sim(:,25) = FLUX1(:,27);
F1_sim(:,26) = FLUX1(:,30);
F1_sim(:,27) = FLUX1(:,31);
F1_sim(:,28) = FLUX1(:,36);

F1_sim_interp = zeros(6,28);
for i = 1:6
    for j = 1:28
        F1_sim_interp(i,j) = interp1(T1,F1_sim(:,j),T1_exp(i));
    end
end

for i = 1:3
    %F1_sim_interp(i,:) = F1_sim_interp(i,:) ./ F1_sim_interp(i,1) * 100;
    %relative flux
    F1_sim_interp(i,:) = F1_sim_interp(i,:)/564;  
end
for i = 4:6
    F1_sim_interp(i,10) = - F1_sim_interp(i,10);
    %F1_sim_interp(i,:) = F1_sim_interp(i,:) ./ F1_sim_interp(i,10) * 100;
    %relative flux
    F1_sim_interp(i,:) = F1_sim_interp(i,:) /564; 
end

F1_exp(:,5) = [];
F1_sim_interp(:,5) = [];

scrsz = get(0,'ScreenSize');
h = figure('Position',[10 scrsz(4)*0.24 scrsz(3)*0.24 scrsz(4)*0.24]);
hold on;
plot([-1e+3 1e+3],[-1e+3 1e+3],'k-');
xlabel('Measured Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
ylabel('Simulated Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
title('WT (Glucose consumption phase)','FontSize',10,'FontName','Arial');
plot(F1_exp(1,:)',F1_sim_interp(1,:)','bo');hold on;
plot(F1_exp(2,:)',F1_sim_interp(2,:)','gd');hold on;
plot(F1_exp(3,:)',F1_sim_interp(3,:)','rs');
xlim([-10 30])
ylim([-10 30])
legend('-','5 h','6 h','7 h');
hold off;

scrsz = get(0,'ScreenSize');
h = figure('Position',[10 scrsz(4)*0.24 scrsz(3)*0.24 scrsz(4)*0.24]);
hold on;
plot([-1e+3 1e+3],[-1e+3 1e+3],'k-');
xlabel('Measured Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
ylabel('Simulated Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
title('WT (Acetate consumption phase)','FontSize',10,'FontName','Arial');
plot(F1_exp(4,:)',F1_sim_interp(4,:)','bo');hold on;
plot(F1_exp(5,:)',F1_sim_interp(5,:)','gd');hold on;
plot(F1_exp(6,:)',F1_sim_interp(6,:)','rs');
xlim([-5 10])
ylim([-5 10])
legend('-','8 h','8.5 h','9 h');
hold off;

%% DeltaPyk Flux in comparison with Toya 2010
[ T2_exp, F2_exp ] = ExpDataForBatchCulture_Flux(2);
F2_sim(:, 1) = FLUX2(:,3);
F2_sim(:, 2) = FLUX2(:,8);
F2_sim(:, 3) = FLUX2(:, 9) - FLUX2(:,10);
F2_sim(:, 4) = FLUX2(:,11);
F2_sim(:, 5) = 0; % F_sim does not have Tpi
F2_sim(:, 6) = FLUX2(:,12);
F2_sim(:, 7) = FLUX2(:,12);
F2_sim(:, 8) = FLUX2(:,13) - FLUX2(:,14);
F2_sim(:, 9) = FLUX2(:,15);
F2_sim(:,10) = FLUX2(:,17);
F2_sim(:,11) = FLUX2(:,34);
F2_sim(:,12) = FLUX2(:,38);
F2_sim(:,13) = FLUX2(:,40);
F2_sim(:,14) = FLUX2(:,39);
F2_sim(:,15) = FLUX2(:,41);
F2_sim(:,16) = FLUX2(:,43);
F2_sim(:,17) = FLUX2(:,42);
F2_sim(:,18) = FLUX2(:,21);
F2_sim(:,19) = FLUX2(:,22);
F2_sim(:,20) = FLUX2(:,23);
F2_sim(:,21) = FLUX2(:,24);
F2_sim(:,22) = FLUX2(:,25);
F2_sim(:,23) = FLUX2(:,26);
F2_sim(:,24) = FLUX2(:,29) - FLUX2(:,28);
F2_sim(:,25) = FLUX2(:,27);
F2_sim(:,26) = FLUX2(:,30);
F2_sim(:,27) = FLUX2(:,31);
F2_sim(:,28) = FLUX2(:,36);

F2_sim_interp = zeros(3,28);
for i = 1:3
    for j = 1:28
        F2_sim_interp(i,j) = interp1(T2,F2_sim(:,j),T2_exp(i));
    end
end

for i = 1:3
    %F2_sim_interp(i,:) = F2_sim_interp(i,:) ./ F2_sim_interp(i,1) * 100;
    F2_sim_interp(i,:) = F2_sim_interp(i,:)/564;
end

F2_exp(:,5) = [];
F2_sim_interp(:,5) = [];

scrsz = get(0,'ScreenSize');
h = figure('Position',[10 scrsz(4)*0.24 scrsz(3)*0.24 scrsz(4)*0.24]);
hold on;
plot([-1e+3 1e+3],[-1e+3 1e+3],'k-');
xlabel('Measured Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
ylabel('Simulated Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
title('\Deltapyk','FontSize',10,'FontName','Arial');
plot(F2_exp(1,:)',F2_sim_interp(1,:)','bo');hold on;
plot(F2_exp(2,:)',F2_sim_interp(2,:)','gd');hold on;
plot(F2_exp(3,:)',F2_sim_interp(3,:)','rs');
xlim([-10 30])
ylim([-10 30])
legend('-','5 h','6 h','7 h');
hold off;

%% DeltaPgi Flux in comparison with Toya 2010
[ T3_exp, F3_exp ] = ExpDataForBatchCulture_Flux(3);
F3_sim(:, 1) = FLUX3(:,3);
F3_sim(:, 2) = FLUX3(:,8);
F3_sim(:, 3) = FLUX3(:, 9) - FLUX3(:,10);
F3_sim(:, 4) = FLUX3(:,11);
F3_sim(:, 5) = 0; % F_sim does not have Tpi
F3_sim(:, 6) = FLUX3(:,12);
F3_sim(:, 7) = FLUX3(:,12);
F3_sim(:, 8) = FLUX3(:,13) - FLUX3(:,14);
F3_sim(:, 9) = FLUX3(:,15);
F3_sim(:,10) = FLUX3(:,17);
F3_sim(:,11) = FLUX3(:,34);
F3_sim(:,12) = FLUX3(:,38);
F3_sim(:,13) = FLUX3(:,40);
F3_sim(:,14) = FLUX3(:,39);
F3_sim(:,15) = FLUX3(:,41);
F3_sim(:,16) = FLUX3(:,43);
F3_sim(:,17) = FLUX3(:,42);
F3_sim(:,18) = FLUX3(:,21);
F3_sim(:,19) = FLUX3(:,22);
F3_sim(:,20) = FLUX3(:,23);
F3_sim(:,21) = FLUX3(:,24);
F3_sim(:,22) = FLUX3(:,25);
F3_sim(:,23) = FLUX3(:,26);
F3_sim(:,24) = FLUX3(:,29) - FLUX3(:,28);
F3_sim(:,25) = FLUX3(:,27);
F3_sim(:,26) = FLUX3(:,30);
F3_sim(:,27) = FLUX3(:,31);
F3_sim(:,28) = FLUX3(:,36);

F3_sim_interp = zeros(3,28);
for i = 1:3
    for j = 1:28
        F3_sim_interp(i,j) = interp1(T3,F3_sim(:,j),T3_exp(i));
    end
end

for i = 1:3
    %F3_sim_interp(i,:) = F3_sim_interp(i,:) ./ F3_sim_interp(i,1) * 100;
    F3_sim_interp(i,:) = F3_sim_interp(i,:)/564 ;
end

F3_exp(:,5) = [];
F3_sim_interp(:,5) = [];

scrsz = get(0,'ScreenSize');
h = figure('Position',[10 scrsz(4)*0.24 scrsz(3)*0.24 scrsz(4)*0.24]);
hold on;
plot([-1e+3 1e+3],[-1e+3 1e+3],'k-');
xlabel('Measured Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
ylabel('Simulated Flux (mmol g^{-1}h^{-1})','FontSize',10,'FontName','Arial');
set(gca,'FontSize',10,'FontName','Arial');
title('\Deltapgi','FontSize',10,'FontName','Arial');
plot(F3_exp(1,:)',F3_sim_interp(1,:)','bo');hold on;
plot(F3_exp(2,:)',F3_sim_interp(2,:)','gd');hold on;
plot(F3_exp(3,:)',F3_sim_interp(3,:)','rs');
xlim([-5 10])
ylim([-5 10])
legend('-','16 h','21 h','23 h');
hold off;
