clear all;
close all;

global strain_no continuous_flg;
[Yidx, Fidx] = setIndex();


options = odeset('RelTol',1e-10,'AbsTol',1e-10);
n_FLUX = 155;
ode_file = @JahanModel_ODE;
flux_file = @JahanModel_Flux;

%% RF06, WT(Oct),WT, 0.2h-1
SampleID = 'RF06';
strain_no = 1;
continuous_flg = 1;
span = -10:0.1:200;
y0 = getInitialCondition();
y0( 1) = 1; % X
y0( 2) = 1; % GLCex
y0(12) = 1; % ACEex
[ T, Y, FLUX ] = runSimulation(ode_file,flux_file,span,y0,options);
Y = real(Y); FLUX = real(FLUX);
plotContinuousFlux(FLUX(end,:), SampleID)

%% GR02 WT, 0.4h-1
SampleID = 'GR02';
strain_no = 1;
continuous_flg = 3;
span = -10:0.1:200;
y0 = getInitialCondition();
y0( 1) = 1; % X
y0( 2) = 1; % GLCex
y0(12) = 1; % ACEex
[ T, Y, FLUX ] = runSimulation(ode_file,flux_file,span,y0,options);
Y = real(Y); FLUX = real(FLUX);
plotContinuousFlux(FLUX(end,:), SampleID)

%% GR03 WT, 0.5h-1
SampleID = 'GR03';
strain_no = 1;
continuous_flg = 4;
span = -10:0.1:200;
y0 = getInitialCondition();
y0( 1) = 1; % X
y0( 2) = 1; % GLCex
y0(12) = 1; % ACEex
[ T, Y, FLUX ] = runSimulation(ode_file,flux_file,span,y0,options);
Y = real(Y); FLUX = real(FLUX);
plotContinuousFlux(FLUX(end,:), SampleID)

%% GR04 WT, 0.7h-1
SampleID = 'GR04';
strain_no = 1;
continuous_flg = 5;
span = -10:0.1:200;
y0 = getInitialCondition();
y0( 1) = 1; % X
y0( 2) = 1; % GLCex
y0(12) = 1; % ACEex
[ T, Y, FLUX ] = runSimulation(ode_file,flux_file,span,y0,options);
Y = real(Y); FLUX = real(FLUX);
plotContinuousFlux(FLUX(end,:), SampleID)
