function plotSimulationResult(T,Y,FLUX,strain_no,xrange,yrange)

[Yidx, Fidx] = setIndex();

scrsz = get(0,'ScreenSize');
h = figure('Position',[10 scrsz(4)*0.24 scrsz(3)*0.24 scrsz(4)*0.24]);

[ T_exp, X_exp, GLCex_exp, ACEex_exp ] = ExpDataForBatchCulture(strain_no);
hold on;
plot(T_exp,X_exp,'bd', T_exp, GLCex_exp*1e-3*180, 'go', T_exp, ACEex_exp*1e-3*60,'rs');
plot(T, Y(:,Yidx.X),'b-', T,Y(:,Yidx.GLCex)*1e-3*180, 'g-',T, Y(:,Yidx.ACEex)*1e-3*60,'r-','LineWidth',2);
xlabel('Time (h)','FontSize',10,'FontName','Arial');
ylabel('Concentration (g/L)','FontSize',10,'FontName','Arial');
legend('X','GLCex','ACEex',0);
xlim(xrange);
ylim(yrange);
set(gca,'XTick',xrange(1):5:xrange(2));
set(gca,'YTick',0:2:20);
set(gca,'FontSize',10,'FontName','Arial');
hold off;

switch strain_no
    case 1
        title('Wild Type');
    case 2
        title('\Deltapyk');
    case 3
        title('\Deltapgi');
    case 4
        title('\Deltappc');
    otherwise
        fprintf('Unexpected Strain Number!\n');
end
